function [a, a1, a2] = zernike_moments_invariants(ROI_im,max_order)


F=ROI_im;

F1 = -1 + 2.*(F - min(F(:)))./(max(F(:)) - min(F(:)));

L = size(F,1)-1;

x = (-L:2:L)/L;
[X,Y] = meshgrid(x);
[theta,r] = cart2pol(X,Y);

M= []; N = [];
for m = 0:max_order
    M= [M m*ones(1,m+1)];
    N = [N -m:2:m];
end

is_in_circle = ( r <= 1 );

[ax ay]=find_logical(is_in_circle);
   

Z=zeros([length(ax) size(M,2)]) ;
Z1=zeros([length(ax) size(M,2)]) ; aa=[];
FF=reshape(F1(is_in_circle),[length(ax) 1]);

for t=1:size(M,2)
    [ Z(:,t) Z1(:,t)] = zernfun_full(M(t),N(t),r(is_in_circle),theta(is_in_circle));
    
    %    % Case 1 : Khotanzad's method
    
    Pr(:,t)=FF.*Z1(:,t);
    aa(1,t) = nansum(Pr(:,t));        % calculate the moments
    cnt = nnz(r)+1;             % count the number of pixels inside the unit circle
    aa(1,t) = (M(t)+1)*aa(1,t)/cnt;            % normalize the amplitude of moments
    
end
 a=abs(aa); 
 aan=angle(aa)*180/pi; 
%Case 2:Least squares method  with sin, cos based polynomials
% 
 a1= Z\FF;

% %Case 3:Least squares method  with absolute polynomials
% 
 a2= abs(Z1\FF);









end

